#!/usr/bin/php
<?php
#require_once('/opt/TrendMicro/DTAS/ManagementServer/bin/common.php');

function network_config($dhcp_enabled, $hostname, $ip, $mask, $gateway, $ipv6, $ipv6_prefix_length, $ipv6_gateway, $dns, $dns2, $dns3, $interface) {

    // format_ipv6
    $linklocal="fe80:" ;
    
    $test_dns1 = strtolower($dns) ;
    if ( substr($test_dns1, 0, strlen($linklocal)) === $linklocal )
    {
        $dns .= "%$interface" ;
    }
    
    $test_dns2 = strtolower($dns2) ;
    if ( substr($test_dns2, 0, strlen($linklocal)) === $linklocal )
    {
        $dns2 .= "%$interface" ;
    }

    $test_dns3 = strtolower($dns3) ;
    if ( substr($test_dns3, 0, strlen($linklocal)) === $linklocal )
    {
        $dns3 .= "%$interface" ;
    }
   
    $cmd_prefix="";
    if ($interface == "eth1")
    {
        # port binding, use network namespace
        $cmd_prefix = "/usr/sbin/ip netns exec sys-port-ns";
        
    }
 
    // keep current settings
	unset($result_array);
	$current_sys_ip = "";
	exec("$cmd_prefix /sbin/ifconfig $interface | sed -n 's/.*inet \\([0-9\\.]*\\).*/\\1/p' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	if(array_key_exists(0, $result_array))
	{
		$current_sys_ip = $result_array[0];
	}
    #dprint(0, LOG_DEBUG, "current ip from ifconfig $interface: $current_sys_ip");

	unset($result_array);
	$current_sys_mask = "";
	exec("$cmd_prefix /sbin/ifconfig $interface | sed -n 's/.*inet.*netmask \\([0-9\\.]*\\).*/\\1/p' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	if(array_key_exists(0, $result_array))
	{
		$current_sys_mask = $result_array[0];
	}
    #dprint(0, LOG_DEBUG, "current mask from ifconfig $interface: $current_sys_mask");

	unset($result_array);
    $current_sys_gateway = "";
	exec("$cmd_prefix /sbin/ip route | awk '/default/ {print $3}' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
    if(array_key_exists(0, $result_array))
    {
        $current_sys_gateway = $result_array[0];
    }
    #dprint(0, LOG_DEBUG, "current gateway from ip route: $current_sys_gateway");

	unset($result_array);
	$current_sys_dns = "";
	$current_sys_dns2 = "";
	$current_sys_dns3 = "";


        $resolv_file = "/etc/resolv.conf";
        if ($interface == "eth1") # System port, use local bind DNS
        {
            $sys_resolv_path = "/etc/netns/sys-port-ns/";
            exec("/usr/bin/mkdir -p $sys_resolv_path");
            $resolv_file = $sys_resolv_path . "resolv.conf";
            exec("/usr/bin/touch $resolv_file");
        }
	exec("/bin/sed -e '/^$/d' $resolv_file | grep -v \"^#\" | grep \"^nameserver\" | grep -m 3 -i nameserver | awk '{print $2}' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	if(array_key_exists(0, $result_array))
    {
            $current_sys_dns = str_replace("%$interface", "", $result_array[0]);
	}
    if(array_key_exists(1, $result_array))
    {
            $current_sys_dns2 = str_replace("%$interface", "", $result_array[1]);
    }
    
    if(array_key_exists(2, $result_array))
    {
            $current_sys_dns3 = str_replace("%$interface", "", $result_array[2]);
    }
    #dprint(0, LOG_DEBUG, "current dns from $resolv_file: $current_sys_dns $current_sys_dns2");

	unset($result_array);
	$current_sys_ipv6 = "";
	$current_sys_ipv6_prefix_length = "";
	exec("$cmd_prefix /sbin/ifconfig $interface | grep 'inet6 ' | grep '<global>' | awk '{print $2}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	if(array_key_exists(0, $result_array))
	{
		$current_sys_ipv6 = $result_array[0];
		unset($result_array);
		exec("$cmd_prefix /sbin/ifconfig $interface | grep 'inet6 ' | grep '<global>' | sed -n 's/.*prefixlen \\([0-9\\.]*\\).*/\\1/p' 2>&1", $result_array, $return_value);
		if($return_value != 0) exit($return_value);
		if(array_key_exists(0, $result_array))
		{
			$current_sys_ipv6_prefix_length = $result_array[0];
		}
	} else {
		unset($result_array);
		//exec("/sbin/ifconfig $interface | grep 'inet6 addr:' | grep 'Scope:Link' | awk '{print $3}' | awk -F'/' '{print $1}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
		exec("grep 'IPV6ADDR=' /etc/sysconfig/network-scripts/ifcfg-$interface | awk -F'=' '{print $2}' | awk -F'/' '{print $1}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
		if($return_value != 0) exit($return_value);
		if(array_key_exists(0, $result_array))
		{
			$current_sys_ipv6 = $result_array[0];
			unset($result_array);
			//exec("/sbin/ifconfig $interface | grep 'inet6 addr:' | grep 'Scope:Link' | awk '{print $3}' | awk -F'/' '{print $2}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
			exec("grep 'IPV6ADDR=' /etc/sysconfig/network-scripts/ifcfg-$interface | awk -F'=' '{print $2}' | awk -F'/' '{print $2}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
			if($return_value != 0) exit($return_value);
			if(array_key_exists(0, $result_array))
			{
				$current_sys_ipv6_prefix_length = $result_array[0];
			}
		} else {
			unset($result_array);
			exec("$cmd_prefix /sbin/ifconfig $interface | grep 'ether ' | awk '{print $2}' | tr '[a-z]' '[A-Z]'", $result_array, $return_value);
			if($return_value != 0) exit($return_value);
			if(array_key_exists(0, $result_array))
			{
				$mac_addr = $result_array[0];
				unset($result_array);
				exec("/usr/bin/ipv6calc --action prefixmac2ipv6 --in prefix+mac --out ipv6addr fe80:: $mac_addr | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
				if($return_value != 0) exit($return_value);
				if(array_key_exists(0, $result_array))
				{
					$current_sys_ipv6 = $result_array[0];
					$current_sys_ipv6_prefix_length = "64";
				}
			}
		}
	}
    #dprint(0, LOG_DEBUG, "current ipv6 from ifconfig $interface: $current_sys_ipv6");
    #dprint(0, LOG_DEBUG, "current ipv6 prefix length from ifconfig $interface: $current_sys_ipv6_prefix_length");

	unset($result_array);
    $current_sys_ipv6_gateway = "";
	exec("$cmd_prefix /sbin/ip -6 route | grep -v 'kernel' | awk '/default/ {print $3}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
    if(array_key_exists(0, $result_array))
    {
        $current_sys_ipv6_gateway = $result_array[0];
    }
    #dprint(0, LOG_DEBUG, "current ipv6 gateway from ip -6 route: $current_sys_ipv6_gateway");



    $need_restart_network = 1;
    if ($ip == $current_sys_ip && $mask == $current_sys_mask && $gateway == $current_sys_gateway && $ipv6 == $current_sys_ipv6 && $ipv6_prefix_length == $current_sys_ipv6_prefix_length && $ipv6_gateway == $current_sys_ipv6_gateway &&  $dns == $current_sys_dns && $dns2 == $current_sys_dns2 && $dns3 == $current_sys_dns3)
    {
        $need_restart_network = 0;
    }
    #dprint(0, LOG_DEBUG, "need_restart_network = $need_restart_network");

	// setup network ip, mask, gateway
	unset($result_array);
	$cmd_str = "sed -i";
        $cmd_str =$cmd_str . " -e '/^IPADDR=.*\$/d'";
        $cmd_str =$cmd_str . " -e '/^NETMASK=.*\$/d'";
        $cmd_str =$cmd_str . " -e '/^PREFIX=.*\$/d'";
        $cmd_str =$cmd_str . " -e '/^GATEWAY=.*\$/d'";
        $cmd_str =$cmd_str . " -e '/^IPV6ADDR=.*\$/d'";
        $cmd_str =$cmd_str . " -e '/^IPV6_DEFAULTGW=.*\$/d'";
        $cmd_str =$cmd_str . " /etc/sysconfig/network-scripts/ifcfg-$interface";
	exec($cmd_str, $result_array, $return_value);

	unset($result_array);
	$cmd_str = "sed -i";
	if($dhcp_enabled) {
            $cmd_str =$cmd_str . " -e 's/^BOOTPROTO=.*\$/BOOTPROTO=dhcp/g'";
        } else {
            $cmd_str =$cmd_str . " -e 's/^BOOTPROTO=.*\$/BOOTPROTO=none/g'";
            if ($interface == "eth0") # management port setting, set onboot to yes
            {
                $cmd_str =$cmd_str . " -e 's/^ONBOOT=.*\$/ONBOOT=yes/g'";
            }
            if($ip != "") {
                $cmd_str =$cmd_str . " -e '\$a IPADDR=" . $ip . "'";
                $cmd_str =$cmd_str . " -e '\$a NETMASK=" . $mask . "'";
                $cmd_str =$cmd_str . " -e '\$a GATEWAY=" . $gateway . "'";
            }
	    if($ipv6 != "") {
                $cmd_str =$cmd_str . " -e '\$a IPV6ADDR=" . $ipv6 . "/" . $ipv6_prefix_length . "'";
                if ($ipv6_gateway != "") {
		    $cmd_str =$cmd_str . " -e '\$a IPV6_DEFAULTGW=" . $ipv6_gateway . "'";
                }
            }
        }
        $cmd_str =$cmd_str . " /etc/sysconfig/network-scripts/ifcfg-$interface";
	exec($cmd_str, $result_array, $return_value);

	// setup DNS
	$resolv_file = "/etc/resolv.conf";
        if ($interface == "eth1")  # System  port will use local bind resolv.conf
        {
            $sys_resolv_path = "/etc/netns/sys-port-ns/";
            exec("/usr/bin/mkdir -p $sys_resolv_path");
            $resolv_file = $sys_resolv_path . "resolv.conf";
            exec("/usr/bin/touch $resolv_file");
        }
	$fh_resolv = fopen($resolv_file, 'w') or die("can't open $resolv_file");
	if ($dns != "" || $dns2 != "" || $dns3 != "" ) {
		if ($dns != "") {
			fwrite($fh_resolv, "nameserver $dns\n");
		}
		if ($dns2 != "") {
			fwrite($fh_resolv, "nameserver $dns2\n");
		}
		if ($dns3 != "") {
			fwrite($fh_resolv, "nameserver $dns3\n");
		}
	}
	fclose($fh_resolv);

	if ($hostname != "")
	{
		//setup hostname
		$network_file = "/etc/sysconfig/network";
		$fh_network = fopen($network_file, 'w') or die("can't open file");

		fwrite($fh_network, "NETWORKING=yes\n");
		fwrite($fh_network, "NETWORKING_IPV6=yes\n");
		fwrite($fh_network, "IPV6_AUTOCONF=no\n");
		fwrite($fh_network, "HOSTNAME=$hostname\n");
		fwrite($fh_network, "NOZEROCONF=yes\n");

		fclose($fh_network);
		
		exec("/bin/hostname 2>&1", $result_array, $return_value); 
		$hosts_file = "/etc/hosts";
		
		exec("/opt/TrendMicro/Pixiebob/textUI/backend_functions/update_hostname.sh $hostname", $result_array, $return_value);
                if($return_value != 0)
                {
                     if(array_key_exists(0, $result_array))
                     {
                        #dprint(0, LOG_ERR, "Error: ifup return $result_array[0]");
                        echo "SYSTEM_ERROR $result_array[0]";
                     }
                    return; 
                }            		
	}

	// restart network
    if($dhcp_enabled || $need_restart_network == 1) {
		#dprint(0, LOG_DEBUG, "Do ifdown and ifup");
		unset($result_array);
    	exec("$cmd_prefix /sbin/ifdown $interface 2>&1");
    	exec("$cmd_prefix /sbin/ifup $interface 2>&1", $result_array, $return_value);
        if($return_value != 0)
		{
			if(array_key_exists(0, $result_array))
			{
				#dprint(0, LOG_ERR, "Error: ifup return $result_array[0]");
				echo "SYSTEM_ERROR $result_array[0]";
			}
			return;
		}
    }

	unset($result_array);
	exec("/usr/bin/hostname 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	$sys_hostname = $result_array[0];
    #dprint(0, LOG_DEBUG, "hostname from hostname command: $sys_hostname");

	unset($result_array);
	$sys_ip = "";
	exec("$cmd_prefix /sbin/ifconfig $interface | sed -n 's/.*inet \\([0-9\\.]*\\).*/\\1/p' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
        if(array_key_exists(0, $result_array))
        {
            $sys_ip = $result_array[0];
        }
        else
        {
            echo "SYSTEM_ERROR Type a valid IPv4 address.";
            return;
        }
    #dprint(0, LOG_DEBUG, "ip from ifconfig $interface: $sys_ip");

	unset($result_array);
	$sys_mask = "";
	exec("$cmd_prefix /sbin/ifconfig $interface | sed -n 's/.*inet.*netmask \\([0-9\\.]*\\).*/\\1/p' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
        if(array_key_exists(0, $result_array))
        {
            $sys_mask = $result_array[0];
        }
        else
        {
            echo "SYSTEM_ERROR Type a valid subnet mask.";
            return;
        }

    #dprint(0, LOG_DEBUG, "mask from ifconfig $interface: $sys_mask");

	unset($result_array);
    $sys_gateway = "";
	exec("$cmd_prefix /sbin/ip route | awk '/default/ {print $3}' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
        if(array_key_exists(0, $result_array))
        {
            $sys_gateway = $result_array[0];
        }
        else
        {
            echo "SYSTEM_ERROR Type a valid IPv4 gateway address.";
            return;
        }
    #dprint(0, LOG_DEBUG, "gateway from ip route: $sys_gateway");

	unset($result_array);
	$sys_dns = "";
	$sys_dns2 = "";
	$sys_dns3 = "";
        $resolv_file = "/etc/resolv.conf";
        if ($interface == "eth1") # System port will use local bind DNS
        {
            $sys_resolv_path = "/etc/netns/sys-port-ns/";
            exec("/usr/bin/mkdir -p $sys_resolv_path");
            $resolv_file = $sys_resolv_path . "resolv.conf";
            exec("/usr/bin/touch $resolv_file");
        }
	exec("/bin/sed -e '/^$/d' $resolv_file | grep -v \"^#\" | grep \"^nameserver\" | grep -m 3 -i nameserver | awk '{print $2}' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	if(array_key_exists(0, $result_array))
    {
		$sys_dns = $result_array[0];
	}
    if(array_key_exists(1, $result_array))
    {
	    $sys_dns2 = $result_array[1];
    }

    if(array_key_exists(2, $result_array))
    {
	    $sys_dns3 = $result_array[2];
    }
    #dprint(0, LOG_DEBUG, "dns from $resolv_file: $sys_dns $sys_dns2");

	unset($result_array);
	$sys_ipv6 = "";
	$sys_ipv6_prefix_length = "";
    $sys_ipv6_gateway = "";
	exec("$cmd_prefix /sbin/ifconfig $interface | grep 'inet6 ' | grep '<global>' | awk '{print $2}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
	if($return_value != 0) exit($return_value);
	if(array_key_exists(0, $result_array) && ("$ipv6" != "") && !(substr($ipv6, 0, 5) === "FE80:"))
	{
		$sys_ipv6 = $result_array[0];
		unset($result_array);
		exec("$cmd_prefix /sbin/ifconfig $interface | grep 'inet6 ' | grep '<global>' | sed -n 's/.*prefixlen \\([0-9\\.]*\\).*/\\1/p' 2>&1", $result_array, $return_value);
		if($return_value != 0) exit($return_value);
		if(array_key_exists(0, $result_array))
		{
			$sys_ipv6_prefix_length = $result_array[0];
		}
	

                unset($result_array);
                exec("$cmd_prefix /sbin/ip -6 route | grep -v 'kernel' | awk '/default/ {print $3}' | tr '[a-z]' '[A-Z]' 2>&1", $result_array, $return_value);
                if($return_value != 0) exit($return_value);
                if(array_key_exists(0, $result_array))
                {
                    $sys_ipv6_gateway = $result_array[0];
                }
	}

        if ("$ipv6" != "" && "$sys_ipv6" == "")
        {
            echo "SYSTEM_ERROR Type a valid IPv6 address.";
            return;
        }

        if ("$ipv6_prefix_length" != "" && "$sys_ipv6_prefix_length" == "")
        {
            echo "SYSTEM_ERROR Type a valid prefix length.";
            return;
        }
         
        if ("$ipv6_gateway" != "" && "$sys_ipv6_gateway" == "")
        {
            echo "SYSTEM_ERROR Type a valid IPv6 gateway address.";
            return;
        }
	
    #dprint(0, LOG_DEBUG, "ipv6 from ifconfig $interface: $sys_ipv6");
    #dprint(0, LOG_DEBUG, "ipv6 prefix length from ifconfig $interface: $sys_ipv6_prefix_length");

    #dprint(0, LOG_DEBUG, "ipv6 gateway from ip -6 route: $sys_ipv6_gateway");

    #dprint(0, LOG_DEBUG, "Ha sync :ha_ctrl.py --sync-info");
    echo "$sys_hostname,$sys_ip,$sys_mask,$sys_gateway,$sys_ipv6,$sys_ipv6_prefix_length,$sys_ipv6_gateway,$sys_dns,$sys_dns2,$sys_dns3, $interface";
}

if(count($argv) < 2) {
	echo "Usage: network_config DHCP HOSTNAME IP MASK GATEWAY IPV6 IPV6_PREFIX_LENGTH IPV6_GATEWAY DNS DNS2 DNS3 INTERFACE \n";
	exit(1);
}

$dhcp_enabled = $argv[1];
if(!$dhcp_enabled) {
	if(count($argv) < 13) {
		echo "Usage: network_config DHCP HOSTNAME IP MASK GATEWAY IPV6 IPV6_PREFIX_LENGTH IPV6_GATEWAY DNS DNS2 DNS3 INTERFACE\n";
		exit(1);
	}
}

$hostname = $dhcp_enabled ? "" : $argv[2];
$ip = $dhcp_enabled ? "" : $argv[3];
$mask = $dhcp_enabled ? "" : $argv[4];
$gateway = $dhcp_enabled ? "" : $argv[5];
$ipv6 = $dhcp_enabled ? "" : $argv[6];
$ipv6_prefix_length = $dhcp_enabled ? "" : $argv[7];
$ipv6_gateway = $dhcp_enabled ? "" : $argv[8];
$dns = $dhcp_enabled ? "" : $argv[9];
$dns2 = $dhcp_enabled ? "" : $argv[10];
$dns3 = $dhcp_enabled ? "" : $argv[11];
$interface = $argv[12];

exit(network_config($dhcp_enabled, $hostname, $ip, $mask, $gateway, $ipv6, $ipv6_prefix_length, $ipv6_gateway, $dns, $dns2, $dns3, $interface));

